'use strict';

angular.module('genisis').service('user', ['api', 'session', '$location',
  '$rootScope',
  function ($api, $session, $location, $rootScope) {
    //try to load an existing user session
    var _user = $session.get('user');

    /**
     * Return the user  object
     * @return Object the user's info
     **/
    this.info = function () {
      return _user;
    };

    /**
     * Login
     * @param string email
     * @param string password
     * @return boolean login status
     **/
    this.login = function (email) {

      var payload = {
        value: email,
        context: 'email',
        data: null
      };

      return $api.retrieve('users', payload).then(
        function (request) {
          if (request && request.success) {

            //update the user object with the api payload
            _user = request.response;

            //save the user session
            $session.set('user', _user);

            $location.path('/requests');
            $location.replace();
            return true;
          } else if (request && request.message) {
            $rootScope.errors.push(request.message);
          } else {
            $rootScope.errors.push('Invalid API Response');
          }

          return false;
        }
      );
    };

    /**
     * Logging out of GenISIS system
     * Clear user session and redirect to the login page
     **/
    this.logout = function () {
      $session.delete();
      _user = {};
      $location.path('/logout');
      $location.replace();
    };

    /**
     * Return the name of the user id
     * @return int user id number
     **/
    this.id = function () {
      return _user.emailId;
    };

    this.email = function () {
      return _user.email;
    };

    /**
     * Return the name of the user
     * @return string first and last name
     **/
    this.name = function () {
      return _user.firstName + ' ' + _user.lastName;
    };

    /**
     * Figure out if this user is logged in or not
     * @return boolean valid user data
     **/
    this.loggedIn = function () {
      if (_user.userId !== undefined) {
        return true;
      }

      return false;
    };

    /**
     * Return the role of this user
     * @return string user's role
     **/
    this.permissions = function () {
      return _user.role;
    };

    /**
     * Check if the user is a requester
     * @return boolean
     **/
    this.requester = function () {
      return _user.role === 'requester' ? true : false;
    };

    /**
     * Check if the user is a data destination manager
     * @return boolean
     **/
    this.destinationMgr = function () {
      return _user.role === 'dataDestinationManager' ? true : false;
    };

    /**
     * Check if the user is a data source manager
     * @return boolean
     **/
    this.sourceMgr = function () {
      return _user.role === 'dataSourceManager' ? true : false;
    };

    /**
     * Check if the user is a admin
     * @return boolean
     **/
    this.admin = function () {
      return _user.role === 'admin' ? true : false;
    };

    this.allowedToAccess = function (path) {
      switch (path) {
      case 'createRequest':
        if (this.sourceMgr()) {
          return false;
        } else {
          return true;
        }
        break;
      case null:
        return true;
      }
    };
  }
]);